function updateControlPageSelect() {
    $("#controlPortSelect").append($("<option></option>").val("rs-232").text("RS-232"));
    $("#controlPortSelect").append($("<option></option>").val("rs-422").text("RS-422"));

    $("#baudRateSelect").append($("<option></option>").val("9600").text("9600"));
    $("#baudRateSelect").append($("<option></option>").val("38400").text("38400"));

    $("#protocolSelect").append($("<option></option>").val("visca").text("VISCA"));
    $("#protocolSelect").append($("<option></option>").val("pelcod").text("Pelco D"));

    $("#tallyLampSelect").append($("<option></option>").val("on").text("Enable"));
    $("#tallyLampSelect").append($("<option></option>").val("off").text("Disable"));

    $("#tallyCMMDModeSelect").append($("<option></option>").val("normal").text("Normal"));
    $("#tallyCMMDModeSelect").append($("<option></option>").val("link").text("Link"));
}

function updateControlPageValue() {
    $("#controlPortSelect").val(cameraSettings.ControlPort);
    $("#baudRateSelect").val(cameraSettings.BaudRate);
    $("#protocolSelect").val(cameraSettings.Protocol);
    $("#viscaAddressNumberInput").val(cameraSettings.ViscaAddress);
    $("#pelcoDAddressNumberInput").val(cameraSettings.PelcoDAddress);
    $("#tallyLampSelect").val(cameraSettings.TallyControl);
    $("#tallyCMMDModeSelect").val(cameraSettings.TallyCMMDMode);
}

function updateProtocol() {
    if ($("#protocolSelect").val() == "visca") {
        document.getElementById("viscaAddressNumberInput").disabled = false;
        document.getElementById("viscaAddressNumberMinusButtonInput").disabled = false;
        document.getElementById("viscaAddressNumberPlusButtonInput").disabled = false;
        document.getElementById("pelcoDAddressNumberInput").disabled = true;
        document.getElementById("pelcoDAddressNumberMinusButtonInput").disabled = true;
        document.getElementById("pelcoDAddressNumberPlusButtonInput").disabled = true;
    } else {
        document.getElementById("viscaAddressNumberInput").disabled = true;
        document.getElementById("viscaAddressNumberMinusButtonInput").disabled = true;
        document.getElementById("viscaAddressNumberPlusButtonInput").disabled = true;
        document.getElementById("pelcoDAddressNumberInput").disabled = false;
        document.getElementById("pelcoDAddressNumberMinusButtonInput").disabled = false;
        document.getElementById("pelcoDAddressNumberPlusButtonInput").disabled = false;
    }
}

function saveControlSettings() {
    var cgiParam = {};
    addTime = 0;
    urlToSend = "/command/tally.cgi?";

    cgiParam.TallyControl = $("#tallyLampSelect").val();
    cgiParam.TallyCMMDMode = $("#tallyCMMDModeSelect").val();
    AddParameter("TallyControl", cgiParam.TallyControl);
    AddParameter("TallyCMMDMode", cgiParam.TallyCMMDMode);

    blockUIforPage();
    $.ajax({
        url: urlToSend,
        type: "POST",
        error: function (xhr) {
            UnblockUIforPage();
            console.log("Send Control Setting Error");
            alert("Fail to set, please try again");
        },
        success: function (response) {
            if (cameraSettings.ViewerMode != 0 || cameraSettings.ModelName == "CV420e") {
                reloadControl();
                UnblockUIforPage();
                return;
            }
            addTime = 0;
            urlToSend = "/command/system.cgi?";

            cgiParam.ControlPort = $("#controlPortSelect").val();
            cgiParam.BaudRate = $("#baudRateSelect").val();
            cgiParam.Protocol = $("#protocolSelect").val();
            cgiParam.ViscaAddress = $("#viscaAddressNumberInput").val();
            cgiParam.PelcoDAddress = $("#pelcoDAddressNumberInput").val();
            AddParameter("ControlPort", cgiParam.ControlPort);
            AddParameter("BaudRate", cgiParam.BaudRate);
            AddParameter("Protocol", cgiParam.Protocol);
            AddParameter("ViscaAddress", cgiParam.ViscaAddress);
            AddParameter("PelcoDAddress", cgiParam.PelcoDAddress);

            $.ajax({
                url: urlToSend,
                type: "POST",
                error: function (xhr) {
                    UnblockUIforPage();
                    console.log("Send Control Setting Error");
                    alert("Fail to set, please try again");
                },
                success: function (response) {
                    console.log("Control settings saved to " + cameraSettings.CameraName);
                    reloadControl();
                    UnblockUIforPage();
                }
            });
        }
    });
}

function reloadControl() {
    openControl();
}

function openControl() {
    $("#DivMainPage").load("./page/control.html", function () {
        window.LanguageManager.InitLanguageOfPage();
        if(!isAuthenticated && !isViewerLogin)
            return;

        if (cameraSettings.ViewerMode != 0 || cameraSettings.ModelName == "CV420e") {
            $("#Tr_ControlPort").hide();
            $("#Tr_BaudRate").hide();
            $("#Tr_Protocol").hide();
            $("#Tr_ViscaAddr").hide();
            $("#Tr_PelcodAddr").hide();
        }
        $.ajax({
            url: "/command/inquiry.cgi?inqjs=main&inqjs=network&inqjs=system&inqjs=tally",
            type: "GET",
            error: function (xhr) {
                console.log("Get system info fail");
            },
            success: function (response) {
                var pcDateNow = {};
                const regEx = /var\s(.*?)\=\"(.*?)\"/gm;
                var result = [];
                while (result = regEx.exec(response)) {
                    cameraSettings[result[1]] = result[2];
                }

                updateControlPageSelect();
                updateControlPageValue();
                updateProtocol();
                connectButtonToInput("#viscaAddressNumberMinusButtonInput", "#viscaAddressNumberPlusButtonInput", "#viscaAddressNumberInput", cameraSettings, "ViscaAddress", 0, 7, 1, 0, null);
                connectButtonToInput("#pelcoDAddressNumberMinusButtonInput", "#pelcoDAddressNumberPlusButtonInput", "#pelcoDAddressNumberInput", cameraSettings, "PelcoDAddress", 1, 255, 1, 0, null)
                $("#protocolSelect").change(function () {
                    updateProtocol();
                });
                $("#applyButton").on('click', saveControlSettings);
                $("#cancelButton").on('click', reloadControl);
            }
        });
    });
}
